﻿using System;
using System.Collections.Specialized;
using System.IO;
using System.Reflection;
using System.Web;
using System.Web.Mvc;
using System.Web.Routing;
using System.Web.SessionState;
using HIPS.Web.UI;
using HIPS.Web.UI.Controllers;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Moq;
using SpecsFor.Mvc;

namespace HIPS.Web.Test.Integration
{
    [TestClass]
    public class ErrorHandlerTests
    {
        private static MvcWebApp App { get; set; }

        [ClassInitialize]
        public static void ClassInitialize(TestContext testContext)
        {
            App = new MvcWebApp();
        }

        [TestMethod]
        public void NonExistentUrl_ReturnsCustom404()
        {
            //act
            App.NavigateTo<HomeController>(c => c.Index());
            string url = App.Browser.Url;
            App.Browser.Navigate().GoToUrl(url + "testtesttest");


            //assert
            Assert.IsTrue(App.AllText().Contains("Forbid"));
        }


        private HandleErrorAttribute attribute;
        private ExceptionContext exceptionContext;
        private readonly Mock<HttpRequestBase> mockRequest = new Mock<HttpRequestBase>();
        private readonly Mock<HttpContextBase> mockContext = new Mock<HttpContextBase>();
        private readonly Mock<HttpResponseBase> mockResponse = new Mock<HttpResponseBase>();

        [TestInitialize]
        public void Setup()
        {
            attribute = new HandleErrorAttribute();

            mockContext.Setup(c => c.Request).Returns(mockRequest.Object);

            mockContext.Setup(c => c.Response).Returns(mockResponse.Object);

            mockContext.Setup(c => c.IsCustomErrorEnabled).Returns(true);

            exceptionContext = new ExceptionContext()
            {
                HttpContext = mockContext.Object,
                Exception = new HttpException()
            };
        }
        /// <summary>
        /// HttpContext.Current
        /// </summary>
        /// 
        /// 
        /// 
        public class ControllerFactoryReturnsNull : IControllerFactory
        {
            public IController CreateController(RequestContext context, string controllerName)
            {
                return new TestController();
            }

            public SessionStateBehavior GetControllerSessionBehavior(RequestContext requestContext, string controllerName)
            {
                return SessionStateBehavior.Default;
            }

            public void ReleaseController(IController controller)
            {
            }
        }

        public class TestController : Controller
        {
            public ViewResult TestThrowsException()
            {
                throw new Exception("TEST");
            }
        }

        [TestMethod]
        public void WhenAlreadyHandledThenResultPreserved()
        {
            using (MvcApplication m = new MvcApplication())
            {
                
                //HttpServerUtility u = (HttpServerUtility)typeof(HttpServerUtility).GetConstructor(
                //  BindingFlags.NonPublic | BindingFlags.Instance,
                //  null, new [] { typeof(HttpApplication) }, null).Invoke(new object[] { m });

          
                

                using (StringWriter sw = new StringWriter())
                {
                   var mm = typeof (HttpServerUtility).GetMethod("ExecuteLocalRequestAndCaptureResponse",
                        BindingFlags.NonPublic | BindingFlags.Static);
                   HttpContext context = new HttpContext(new HttpRequest("/", "http://localhost:123/", string.Empty), new HttpResponse(sw));
                   context.ApplicationInstance = m;

                 //   mm.Invoke(m.Server, new object[] { "/", sw, null });
                    context.Server.Execute("/", sw);
                    string s = sw.ToString();
                }
                //var rc = ((MvcHandler)mockContext.Object.CurrentHandler).RequestContext;
                //var factory = ControllerBuilder.Current.GetControllerFactory();

                //var controller = factory.CreateController(rc, controllerName);
                //m.
                //HttpContext.Current = mockContext.Object;
            }

            exceptionContext.ExceptionHandled = true;
            attribute.OnException(exceptionContext);
            Assert.IsInstanceOfType(exceptionContext.Result, typeof(EmptyResult));
        }

        [TestMethod]
        public void WhenCustomErrorsNotEnabledThenResultPreserved()
        {
            mockContext.Setup(htx => htx.IsCustomErrorEnabled)
                        .Returns(false);
            attribute.OnException(exceptionContext);
            Assert.IsInstanceOfType(exceptionContext.Result, typeof(EmptyResult));
        }

        [TestMethod]
        public void WhenExceptionTypeDiffersThenResultPreserved()
        {
            exceptionContext.Exception = new Exception();
            attribute.OnException(exceptionContext);
            Assert.IsInstanceOfType(exceptionContext.Result, typeof(EmptyResult));
        }

        [TestMethod]
        public void WhenAjaxRequestThenResultIsJsonResult()
        {
            mockRequest.Setup(r => r.Headers)
                        .Returns(new NameValueCollection
                            {
                                {"X-Requested-With", "XMLHttpRequest"}
                            });

            attribute.OnException(exceptionContext);
            Assert.IsInstanceOfType(exceptionContext.Result, typeof(JsonResult));
        }
    }
}
